import React, { Component } from "react";
import { connect } from "react-redux";
import AsyncSelect from 'react-select/lib/Async';

import * as actions from "../Store/Actions/MetaDataActions";

class CountrySelect extends Component {

  onChange = (m) => {

    let models = m;

    if (!Array.isArray(m)) {
      models = [m];
    }

    let modelIds = models.map(m => ({ id: m.value, name: m.label }));

    let { onChange } = this.props;

    onChange(modelIds);
  };

  get = (value, callback) => {
// console.log('get this.props: ', this.props);
    let { get, user, autoSelect, withAllOption, search, errorHandler } = this.props;

    let s = "?name=" + value;

    if (search) {
      s = `?name=${value}&${search}`;
    }

    get(user.auth.access_token, s).then(res => {

      let models = res.data.data.map(m => ({ value: m.id, label: m.name }));

      if (withAllOption) {
        models.unshift({ value: "", label: "All Countries" });
      }

      callback(models);

      if (autoSelect) {
        if (models.length > 0) {
          this.onChange(models[0]);
        }
      }

    }).catch(errorHandler);
  };

  render() {
    const { countries } = this.props;
    console.log('props :  ',this.props);
    console.log(countries);

    return (
      <AsyncSelect
        cacheOptions
        defaultOptions
        defaultValue={(countries) ? countries.map(m => ({ value: m.id, label: m.name })) : []}
        loadOptions={this.get}
        {...this.props}
        onChange={this.onChange}
      />
    );
  }
}

const mapDispatchToProps = () => {
  return {
    get: (token, search) => actions.getCountries(token, search),
  };
};

export default connect(
  null,
  mapDispatchToProps
)(CountrySelect);
