import React, { Component } from "react";
import { connect } from "react-redux";
import FileBase64 from 'react-file-base64';
import ImageUploader from 'react-images-upload';
import Switch from "react-switch";

import alertify from 'alertifyjs';
import TimeRange from 'react-time-range';
import moment from 'moment';
import { errorHandler } from '../../util/functions';
import * as actions from "../../Store/Actions/type";
import * as actionCreater from "../../Store/Actions/CardActions";
import * as settingactionCreater from "../../Store/Actions/ConfigurationActions";

import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faPlusSquare, faMinusSquare } from '@fortawesome/free-solid-svg-icons';
import Languages from '../../Helpers/Languages';
import Validator from '../../Helpers/Validator';
import T from '../../Helpers/Translations';
import SelectSearch from 'react-select-search';
import $ from 'jquery';
import Loader from 'react-loader-spinner';
import { SketchPicker } from 'react-color';

class CreateCard extends Component {
  initState = {
    ...this.props.user,
    name: "", email: "", position: "", specialization: "", field_title: "", field_value: "",
    phone: "", alt_mobile: "", fax: "", office_number: "", whatsapp: "", language: "", language_val: "",
    website: "", waze: "", facebook: "", instagram: "", twitter: "", linkdin: "", google_plus: "", youtube: "",
    users: this.props.user,
    user_id: this.props.user.id,
    slugs: this.props.slugs,
    card_title: "",
    card_video: "",
    card_url: "",
    about_us: "",
    our_vision: "",
    our_application: {text: "", link: ""},
    card_url_typo: false,
    card_links: [],
    our_stories: [],
    startTime: [],
    endTime: [],
    activity_hour: [],
    articles: [],
    employees: [],
    recommendations: [],
    files: [],
    images: [],
    limits: [],
    profile_image: "",
    business_image: "",
    slugCan: "",
    checked: { 
        profile_image: false, 
        business_image: false, 
        images: false, 
        card_video: false, 
        card_links: false,
        success_stories: false,
        about_us: false,
        our_vision: false,
        our_application: false,
        our_stories: false,
        activity_hour: false,
        articles: false,
        employees: false,
        recommendations: false,
    },
    displayColorPicker: false,
    background_color: "#00adb4",
    process: true,
  };

  state = {
      ...this.initState
  };

  onChange = e => {
      this.setState({
          [e.target.name]: (e.target.avatar) ? e.target.avatar[0] : e.target.value
      });
      
      let twist = false;
      if(e.target.value.length > 0){twist = true;}
      this.handleCardToggleFields(e.target.name, twist);
      
  };

  handleCardToggleFields(key, checked) {
      this.setState({
          checked: {
              ...this.state.checked,
              [`${key}`]: checked
          }
      })
  }

  onClick = e => {
    let sta;
    if(this.state.card_url_typo === true){
      if(this.state.card_url.length > 0){
        sta = true;
      }
    } else{ sta = true;}
    this.setState({
      card_url_typo: sta
    });
  }

  onBlur = e => {
    let sta;
    if(this.state.card_url.length > 0){
      sta = true;
    } else {sta = false;}
    this.setState({
      card_url_typo: sta
    });
  }

  get = () => {
      let { getConfigurations, dispatch, user, errorHandler } = this.props;

      getConfigurations(user.auth.access_token).then(res => {

          let d = res.data;
          let c = JSON.stringify(d);
          let conf = JSON.parse(c);
          const config = Object.entries(conf);
          let data = {};

          
          config.forEach(e => {
              data = { ...data, [e[0]]: e[1] }
          });
    
          this.setState({
              limits: data
          });
          
          dispatch({
          type: actions.GET_CONFIGURATIONS,
          payload: config
          });

      }).catch(errorHandler).finally(() => {
          this.setState({
            process: false
          });
      });
  };

  slugs = () =>{
    this.setState({
      process: true
    });

    let { slugs, dispatch, user, errorHandler } = this.props;
        slugs(user.auth.access_token)
            .then(res => {
            this.setState({
                slugs: res.data.data,
            });

            dispatch({
                type: actions.GET_SLUGS,
                payload: res.data.data
            });
            })
            .catch(errorHandler)
            .finally(() => {
            this.setState({
              process: false
            });
        });
  };

  cardUrl = e => {
    const va = this.state.slugs;
    let re = /^[^-?+)(*&^%$#@|;!~`"'\/\\=.<>,_][a-zA-Z0-9-]*$/;
    if(va.length > 0){
      if(e.target.value.length === 0){
        this.setState({
          slugCan: '',
          [e.target.name]: e.target.value
        })
      } else if(va.includes(e.target.value)){
        $('.available-status').css({'color':'red'});
        this.setState({
          slugCan: 'Not Available',
          [e.target.name]: e.target.value
        })
      } else {
        if(e.target.value.match(re) !== null){
          if(e.target.value.length !== null && e.target.value.length < 15){
              $('.available-status').css({'color':'green'})
              this.setState({
                  slugCan: 'Available',
                  [e.target.name]: e.target.value
              })
          }
        }
      }
    }
  };

  // Images
  getProfileImage(files) {this.setState({ profile_image: files }); this.handleCardToggleFields("profile_image", true);}
  getBusinessImage(files) {this.setState({ business_image: files }); this.handleCardToggleFields("business_image", true)}
  getAImages(image, file) {
      let _limit = this.state.limits.limit_images;
      let f_length = file.length;
      let cur_length = f_length;
      
      if(cur_length <= _limit) {
          if(image.length > 0){
              this.setState({images: file}); 
              this.handleCardToggleFields("images", true)
          } else{
              this.handleCardToggleFields("images", false)
          }
      } else{
          file.slice(-1);
          const {dispatch} = this.props;
          errorHandler("Can't Add More than "+_limit+" Images",dispatch,alertify);
          $('.uploadPictureContainer:last-child').children()[0].click()
      }
  }

  addLinks = (e) => {
    let _limit, cur_length, msg, l;
    msg = "Can't Add More than "+_limit;

    if(e === 'card_links'){
      _limit = this.state.limits.limit_custom_links;
      cur_length = this.state.card_links.length;
      msg =+" Card Links";
    } else if(e === 'articles'){
      _limit = this.state.limits.limit_articles;
      cur_length = this.state.articles.length;
      msg =+" Articles";
    } else if(e === 'employees'){
      _limit = this.state.limits.limit_employees;
      cur_length = this.state.employees.length;
      msg =+" Employees";
    } else if(e === 'recommendations'){
      _limit = this.state.limits.limit_recommendations;
      cur_length = this.state.recommendations.length;
      msg =+" Recommendations";
    }
    

    if(cur_length < _limit) {
        this.state[`${e}`].push({title: "", link: ""})
        
        this.setState({
          [`${e}`]: this.state[`${e}`]
        })
        this.handleCardToggleFields(e, true)
    } else{
        const {dispatch} = this.props;
        errorHandler(msg,dispatch,alertify);
    }
  }

  handleLinkText = (f,i, key) => e => {
    let cur_state = [...this.state[`${f}`]];

      cur_state[i][`${key}`] = e.target.value;
      this.setState({
          [`${f}`]: this.state[`${f}`]
      });
  }

  handleLinkDelete = (f, i) => e => {
    let del_card_links = [...this.state[`${f}`]];

    del_card_links.splice(i, 1);
    this.setState({
      [`${f}`]: del_card_links
    }, () => (this.state[`${f}`].length === 0) ? this.handleCardToggleFields([`${f}`], false) : '');
  }

  handleAppLinkText = key => e => {
      let app = this.state.our_application;
      app[`${key}`]= e.target.value;
      this.setState({
          our_application: this.state.our_application
      }, () => (this.state.our_application.text.length === 0 && this.state.our_application.link.length === 0) ? this.handleCardToggleFields("our_application", false) : this.handleCardToggleFields("our_application", true));
  }

  addStory = () => {
      let _limit = this.state.limits.limit_success_stories;
      let cur_length = this.state.our_stories.length;

      if(cur_length < _limit) {
          this.state.our_stories.push("")
          
          this.setState({
              our_stories: this.state.our_stories
          });
          this.handleCardToggleFields("our_stories", true)
      } else{
          const {dispatch} = this.props;
          errorHandler("Can't Add More than "+_limit+" Success Stories",dispatch,alertify);
      }
  }

  handleStoryText = i => e => {
      let our_stories = [...this.state.our_stories];
      our_stories[i] = e.target.value;
      this.setState({
          our_stories: our_stories
      });
  }

  handleStoryDelete = i => e => {
      let del_story = [...this.state.our_stories];
      del_story.splice(i, 1);
      this.setState({
          our_stories: del_story
      }, () => (this.state.our_stories.length === 0) ? this.handleCardToggleFields("our_stories", false) : "");
  }

  addActivity = () => {
    this.state.activity_hour.push({day: "", time: { start: "", startTime: "",end: "", endTime: ""}})

      this.setState({
          activity_hour: this.state.activity_hour            
      })
      this.handleCardToggleFields("activity_hour", true)
  }

  handleActivityDay = (i, key) => e => {
      let activity_hour = [...this.state.activity_hour];

      if(activity_hour.some(activity_h => activity_h[`${key}`] ===  e.target.value)){
          const {dispatch} = this.props;
          errorHandler("Day Already Selected",dispatch,alertify);
      } else{
          activity_hour[i][`${key}`] = e.target.value;
          this.setState({
              activity_hour: this.state.activity_hour
          })
      }
  }

  handleActivityTime = i => e => {
      let activity_hour = [...this.state.activity_hour];
      let startTime = [...this.state.startTime];
      let endTime = [...this.state.endTime];
      
      let key = "time";
      let s_key = "start";
      let st_key = "startTime";
      let e_key = "end";
      let et_key = "endTime";
      

      activity_hour[i][`${key}`][`${s_key}`] = moment(e.startTime).format('hh:mm a');
      activity_hour[i][`${key}`][`${st_key}`] = e.startTime;
      activity_hour[i][`${key}`][`${e_key}`] = moment(e.endTime).format('hh:mm a'); 
      activity_hour[i][`${key}`][`${et_key}`] = e.endTime; 
      
      startTime[i] = e.startTime;
      endTime[i] = e.endTime; 

      this.setState({
          startTime: startTime,
          endTime: endTime,
          activity_hour: activity_hour 
      })
  }

  handleActivityDelete = i => e => {
      let del_activity = [...this.state.activity_hour];
      del_activity.splice(i, 1);
      this.setState({
          activity_hour: del_activity
      }, () => (this.state.activity_hour.length === 0) ? this.handleCardToggleFields("activity_hour", false) : "");
  }

  createCard = () => {
    let { createCard, dispatch, alertify, user, errorHandler } = this.props;

    let va = this.state.slugs;
    if(va.includes(this.state.card_url)){
      alertify.error("Please Choose an Available Url");
      $('html, body').animate({ scrollTop: $('.app-page-title').offset().top }, 500, function(){
        $('#card_url').focus();
      });
      return;
    }

    this.setState({
      process: true
    })

    let {
        name, email, position, specialization, field_title, field_value,
        phone, alt_mobile, fax, office_number, whatsapp, language,
        website, waze, facebook, instagram, twitter, linkdin, google_plus, youtube,
        card_title, card_url, status, images, profile_image, business_image, card_video, users, checked, card_links,
        activity_hour, articles, about_us, our_vision, our_application, our_stories, employees, recommendations, user_id } = { ...this.state };

    const params = {
        name, email, position, specialization, field_title, field_value,
        phone, alt_mobile, fax, office_number, whatsapp, language,
        website, waze, facebook, instagram, twitter, linkdin, google_plus, youtube,
        card_title, card_url, status, 
        images, user_id,
        profile_image: profile_image!=null ? profile_image.base64 : null, 
        business_image: business_image!=null ? business_image.base64 : null, 
        card_video, users, checked, card_links,
        activity_hour, articles, about_us, our_vision, our_application, our_stories, employees, recommendations,
    };

    let err = Validator(params);
    if(err.length !== 0){
      let i = 0
      let sw = 0;
      while(i <= err.length)
      {
        if(err[i] !== undefined){
          $(err[i]).show();
        }
        if(err[i] === '#card-title-error'){sw = 1;}
        i++;
      }


      if(err.length === 1 && sw === 1){
        this.move('#tab-eg15-3', '#card-info-btn')
      } else {
        this.move('#tab-eg15-0', '#basic-info-btn')
      }
      this.setState({
          process: false
      });
      return;
    }



    createCard(user.auth.access_token, params).then(res => {

        dispatch({
            type: actions.CREATE_CARD,
            payload: res.data.data
        });

        this.setState({
            ...this.props.userData, 
            name: "", email: "", position: "", specialization: "", field_title: "", field_value: "",
            phone: "", alt_mobile: "", fax: "", office_number: "", whatsapp: "", language: "",
            website: "", waze: "", facebook: "", instagram: "", twitter: "", linkdin: "", google_plus: "", youtube: "",
            card_title: "", card_url: "",
            status: "", files: [], images: [], profile_image: "", business_image: "", card_video: "",
            checked: { profile_image: false, business_image: false, images: false, card_video: false, card_links: false, success_stories: false, about_us: false, our_vision: false, our_application: false, our_stories: false, activity_hour: false, articles: false, employees: false, recommendations: false },
            card_links: [], activity_hour: [], articles: [], employees: [], recommendations: [], about_us: "",
            our_vision: "", our_application: {text: "", link: ""}, our_stories: [], startTime: [], endTime: [], processing: false, isOpen: false, shown: true,
        })

        this.slugs();
        $('.card-url-typo').addClass('hide-it').removeClass('card-url-typo');
        $('.available-status').html('');
        $('.deleteImage').click();

        alertify.success(res.data.message);

      }).catch(errorHandler).finally(() => {
          this.setState({
              process: false
          });
      });

  };

  changeLang = (e) => {
    this.setState({language: e.value, language_val: e.name });
  }

  move = (k, e) => {
      $('#btn-group a').removeClass('active')
      $('.tab-content div').removeClass('active')
      $(k).addClass('active');
      $(e).addClass('active');
  }


  componentWillMount() {
    this.get();
    this.slugs();
  }

  togglePicker = () => {
    this.setState({ displayColorPicker: !this.state.displayColorPicker })
  };

  closePicker = () => {
    this.setState({ displayColorPicker: false })
  };

  handleColor = (color) => {
    this.setState({ background_color: color.hex })
  };


    render() {
      let lang = $('html').attr('lang').toUpperCase();
      let t = T[0];

      let cc = (this.state.process ? "hide-it" : "");
      let { field_title, field_value } = this.state; 
      field_title = (field_title) ? field_title : "About Us"
      return(
      <div>
        <div>
          {this.state.process ?
            <div class="the-loader">
                <Loader
            type="Triangle"
            color="#00adb4"
            height={100}
            width={100}/>
            </div>
        : '' }
        </div>
        <div id="create-card-form" className={cc}>
          <div className="app-page-title">
            <div className="page-title-wrapper">
              <div className="page-title-heading" >
                <div className="text-left">{t.CreateANewCard[lang]}
                  <div className="page-title-subheading">{t.CreateANewCard_p[lang]}</div>
                </div>
              </div>
            </div>
          </div>

          <div class="main-card mb-3 card">
            <div class="card-body">
              <form onSubmit={this.createCard}>
                <div class="mb-3 text-center">
                    <div role="group" class="btn-group-sm nav btn-group" id="btn-group">
                        <a data-toggle="tab" href="#tab-eg15-0" id="basic-info-btn" class="btn-shadow btn btn-primary show active">{t.BasicInfo[lang]}</a>
                        <a data-toggle="tab" href="#tab-eg15-1" id="contact-info-btn" class="btn-shadow btn btn-primary show">{t.ContactInfo[lang]}</a>
                        <a data-toggle="tab" href="#tab-eg15-2" id="social-info-btn" class="btn-shadow btn btn-primary show">{t.SocialInfo[lang]}</a>
                        <a data-toggle="tab" href="#tab-eg15-3" id="card-info-btn" class="btn-shadow btn btn-primary show">{t.CardInfo[lang]}</a>
                        <a data-toggle="tab" href="#tab-eg15-4" id="card-content-btn" class="btn-shadow btn btn-primary show">{t.CardContent[lang]}</a>
                        <a data-toggle="tab" href="#tab-eg15-5" id="card-links-btn" class="btn-shadow btn btn-primary show">{t.CardLinks[lang]}</a>
                    </div>
                </div>
                <div class="tab-content">
                    <div class="tab-pane show active" id="tab-eg15-0" role="tabpanel">
                      <div className="form-row">
                          <div className="col-md-6">
                              <div className="position-relative form-group">
                                <input onChange={this.onChange} value={this.state.name} name="name" id="name" type="text" className="form-control"/>
                                <label forHtml="name" className={(this.state.name !== '') ? 'show' : ''}>{t.Name[lang]}</label>
                              </div>
                          </div>
                          <div className="col-md-6">
                              <div className="position-relative form-group">
                                <input onChange={this.onChange} value={this.state.email} name="email" id="email" type="email" className="form-control"/>
                                <label forHtml="email" className={(this.state.email !== '') ? 'show' : ''}>{t.Email[lang]}</label>
                                <small class="form-error-mode" id="email-error">Required.</small>
                              </div>
                          </div>
                          <div className="col-md-6">
                              <div className="position-relative form-group">
                                <input onChange={this.onChange} value={this.state.position} name="position" id="position" type="text" className="form-control"/>
                                <label forHtml="position" className={(this.state.position !== '') ? 'show' : ''}>{t.Position[lang]}</label>
                              </div>
                          </div>
                          <div className="col-md-6">
                              <div className="position-relative form-group">
                                <input onChange={this.onChange} value={this.state.specialization} name="specialization" id="specialization" type="text" className="form-control"/>
                                <label forHtml="specialization" className={(this.state.specialization !== '') ? 'show' : ''}>{t.Subscriptions[lang]}</label>
                              </div>
                          </div>
                          <div className="col-md-12">
                            <div className="position-relative row form-group">
                                <label htmlFor="language" className="col-sm-2 col-form-label">{t.SelectLanguage[lang]}</label>
                                <div className="col-sm-12">
                                  <SelectSearch onChange={(e) => this.changeLang(e) } className='select-search-box' options={Languages} value={this.state.language_val} name="language" placeholder={this.state.language_val ? this.state.language_val : t.ChooseYourLanguage[lang] } />
                                  <small className="form-error-mode" id="language-error">{t.PleaseSelectaLanguage[lang]}</small>
                                </div>
                            </div>
                          </div>
                          <div className="col-md-12">
                              <div className="position-relative form-group">
                                <input onChange={this.onChange} value={field_title} name="field_title" id="field_title" type="text" className="form-control"/>
                                <textarea name="field_value" id="field_value" className="form-control" onChange={this.onChange} value={field_value ? field_value : ''} rows="6"></textarea>
                              </div>
                          </div>
                          <div className="col-md-12 mt-2">
                            <input type="text" name="background_color" id="background_color" onClick={ this.togglePicker} value={this.state.background_color} />
                            <label forHtml="background_color" className={(this.state.background_color !== '') ? 'show' : ''}>Background Color</label>
                            { this.state.displayColorPicker ? 
                                <div class="pop-over">
                                  <div class="pop-over-cover" onClick={ this.closePicker }>Select</div>
                                  <SketchPicker color={ this.state.background_color } onChange={ this.handleColor } />
                                </div> 
                            : null }
                          </div>
                          <div className="col-md-12 text-center">
                            <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-dark" type="button"  onClick={ () => this.move('#tab-eg15-1', '#contact-info-btn')}>{t.Next[lang]}</button>
                          </div>
                      </div>
                    </div>
                    <div class="tab-pane show" id="tab-eg15-1" role="tabpanel">
                      <div className="form-row">
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.phone} name="phone" id="phone" type="text" className="form-control"/>
                            <label forHtml="phone" className={(this.state.phone !== '') ? 'show' : ''}>{t.Phone[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.alt_mobile} name="alt_mobile" id="alt_mobile" type="text" className="form-control"/>
                            <label forHtml="alt_mobile" className={(this.state.alt_mobile !== '') ? 'show' : ''}>{t.AlternativeNumber[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.office_number} name="office_number" id="office_number" type="text" className="form-control"/>
                            <label forHtml="office_number" className={(this.state.office_number !== '') ? 'show' : ''}>{t.OfficeNumber[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.fax} name="fax" id="fax" type="text" className="form-control"/>
                            <label forHtml="fax" className={(this.state.fax !== '') ? 'show' : ''}>{t.FaxNumber[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-12">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.whatsapp} name="whatsapp" id="whatsapp" type="text" className="form-control"/>
                            <label forHtml="whatsapp" className={(this.state.whatsapp !== '') ? 'show' : ''}>{t.WhatsappNumber[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-12 text-center">
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-light" type="button"  onClick={ () => this.move('#tab-eg15-0', '#basic-info-btn')}>{t.Previous[lang]}</button>
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-dark" type="button"  onClick={ () => this.move('#tab-eg15-2', '#social-info-btn')}>{t.Next[lang]}</button>
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane show" id="tab-eg15-2" role="tabpanel">
                      <div className="form-row">
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.website} name="website" id="website" type="text" className="form-control"/>
                            <label forHtml="website" className={(this.state.website !== '') ? 'show' : ''}>{t.Website[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.waze} name="waze" id="waze" type="text" className="form-control"/>
                            <label forHtml="waze" className={(this.state.waze !== '') ? 'show' : ''}>{t.Waze[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.facebook} name="facebook" id="facebook" type="text" className="form-control"/>
                            <label forHtml="facebook" className={(this.state.facebook !== '') ? 'show' : ''}>{t.Facebook[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.linkdin} name="linkdin" id="linkdin" type="text" className="form-control"/>
                            <label forHtml="linkdin" className={(this.state.linkdin !== '') ? 'show' : ''}>{t.Linkdin[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.twitter} name="twitter" id="twitter" type="text" className="form-control"/>
                            <label forHtml="twitter" className={(this.state.twitter !== '') ? 'show' : ''}>{t.Twitter[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.google_plus} name="google_plus" id="google_plus" type="text" className="form-control"/>
                            <label forHtml="google_plus" className={(this.state.google_plus !== '') ? 'show' : ''}>{t.GooglePlus[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.instagram} name="instagram" id="instagram" type="text" className="form-control"/>
                            <label forHtml="instagram" className={(this.state.instagram !== '') ? 'show' : ''}>{t.Instagram[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="position-relative form-group">
                            <input onChange={this.onChange} value={this.state.youtube} name="youtube" id="youtube" type="text" className="form-control"/>
                            <label forHtml="youtube" className={(this.state.youtube !== '') ? 'show' : ''}>{t.Youtube[lang]}</label>
                          </div>
                        </div>
                        <div className="col-md-12 text-center">
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-light" type="button"  onClick={ () => this.move('#tab-eg15-1', '#contact-info-btn')}>{t.Previous[lang]}</button>
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-dark" type="button"  onClick={ () => this.move('#tab-eg15-3', '#card-info-btn')}>{t.Next[lang]}</button>
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane show" id="tab-eg15-3" role="tabpanel">
                      <div className="form-row">
                          <div className="col-md-6">
                              <div className="position-relative form-group">
                                <input onChange={this.onChange} value={this.state.card_title} name="card_title" id="card_title" type="text" className="form-control"/>
                                <label forHtml="card_title" className={(this.state.card_title !== '') ? 'show' : ''}>{t.CardTitle[lang]}</label>
                                <small className="form-error-mode" id="card-title-error">Required.</small>
                              </div>
                          </div>
                          <div className="col-md-6">
                              <div className="position-relative form-group">
                                <div className={(this.state.card_url_typo) ? 'card-url-typo' : 'hide-it'}>https://easy-card.co/</div>
                                <input onChange={this.cardUrl} onClick={this.onClick} onBlur={this.onBlur} value={this.state.card_url} name="card_url" id="card_url" type="text" className="form-control"/>
                                <label forHtml="card_url" className={(this.state.card_url !== '') ? 'show' : ''}>{t.CardUrl[lang]}</label>
                                <div className="available-status">{this.state.slugCan}</div>
                              </div>
                          </div>
                      </div>

                      <div className="form-row">
                        <div className="col-md-12">
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "card_video")} checked={this.state.checked.card_video} />
                          </div>
                          <div className="position-relative form-group">
                              <input onChange={this.onChange} value={this.state.card_video} name="card_video" id="card_video" type="text" className="form-control"/>
                              <label forHtml="card_video" className={(this.state.card_video !== '') ? 'show' : ''}>{t.VideoLink[lang]}</label>
                            </div>
                        </div>
                      </div>

                      <div className="form-row">
                        <div className="col-md-12">
                            <span forHtml="about_us" className="col-form-label btn-span">{t.AboutUs[lang]}</span>
                            <div className="d-inline float-right">
                                <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "about_us")} checked={this.state.checked.about_us} />
                            </div>
                            <div className="position-relative form-group">
                              <textarea name="about_us" id="about_us" className="form-control pull-left" value={this.state.about_us} onChange={this.onChange} placeholder={t.AboutUs_p[lang]} rows="8"></textarea>
                            </div>
                        </div>
                      </div>
                      
                      <div className="form-row">
                        <div className="col-md-12">
                            <span forHtml="about_us" className="col-form-label btn-span">{t.OurVision[lang]}</span>
                            <div className="d-inline float-right">
                                <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "our_vision")} checked={this.state.checked.our_vision} />
                            </div>
                            <div className="position-relative form-group">
                              <textarea name="our_vision" id="our_vision" className="form-control pull-left" value={this.state.our_vision} onChange={this.onChange} placeholder={t.OurVision_p} rows="8"></textarea>
                            </div>
                        </div>
                      </div>
                      
                      <div className="form-row">
                        <div className="col-md-12">
                            <span forHtml="about_us" className="col-form-label btn-span">{t.OurApplication[lang]}</span>
                            <div className="d-inline float-right">
                                <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "our_application")} checked={this.state.checked.our_application} />
                            </div>
                            <div className="position-relative form-group">
                              <textarea name="our_application" id="our_application" className="form-control pull-left" value={this.state.our_application.text} onChange={this.handleAppLinkText("text")} placeholder={t.OurApplication_p[lang]} rows="8"></textarea>
                            </div>
                            <div className="position-relative form-group">
                              <input
                                  type="text"
                                  onChange={this.handleAppLinkText("link")}
                                  value={this.state.our_application.link}
                                  className="form-control"
                              />
                              <label htmlFor="our_application" className={(this.state.our_application.link !== '') ? 'show' : ''}>{t.ApplicationLink[lang]}</label>       
                            </div>
                        </div>
                        <div className="col-md-12 text-center">
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-light" type="button"  onClick={ () => this.move('#tab-eg15-2', '#social-info-btn')}>{t.Previous[lang]}</button>
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-dark" type="button"  onClick={ () => this.move('#tab-eg15-4', '#card-content-btn')}>{t.Next[lang]}</button>
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane show" id="tab-eg15-4" role="tabpanel">
                      <div className="form-row">
                        <div className="col-md-6">
                          <div className="image-boxed-model">
                            <span forHtml="profile-image" className="col-form-label btn-span">{t.ProfilePicture[lang]}</span>
                            <div className="d-inline float-right">
                                <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "profile_image")} checked={this.state.checked.profile_image} />
                            </div>
                          </div>
                          <div className="upload-btn-wrapper">
                            <button className="btn">{t.Uploadafile[lang]}</button>
                            <FileBase64
                                multiple={false}
                                className=""
                                onDone={this.getProfileImage.bind(this)}
                            />
                            <div className="file-info">FileName</div>
                            { this.state.profile_image.base64 ?
                              <div className="file-holder">
                              <div className="hover"></div>
                              <img src={this.state.profile_image.base64}  className="file-image" alt="" />
                            </div>
                            : ''}
                          </div>
                        </div>
                        <div className="col-md-6">
                          <div className="image-boxed-model">
                            <span forHtml="business-image" className="col-form-label btn-span">{t.BusinessImage[lang]}</span>
                            <div className="d-inline float-right">
                                <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "business_image")} checked={this.state.checked.business_image} />
                            </div>
                          </div>
                          <div className="upload-btn-wrapper">
                            <button className="btn">{t.Uploadafile[lang]}</button>
                            <FileBase64
                                multiple={false}
                                className=""
                                onDone={this.getBusinessImage.bind(this)}
                            />
                            <div className="file-info">FileName</div>
                            { this.state.business_image.base64 ?
                            <div className="file-holder">
                              <div className="hover"></div>
                              <img src={this.state.business_image.base64} className="file-image" alt="" />
                            </div>
                            : ''}
                          </div>
                        </div>
                      </div>

                      <hr/>

                      <div className="form-row">
                        <div className="col-md-12">
                            <div className="image-boxed-model">
                              <span forHtml="business-image" className="col-form-label btn-span">{t.GalleryImage[lang]}</span>
                              <div className="d-inline float-right">
                                  <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "images")} checked={this.state.checked.images} />
                              </div>
                            </div>
                            <ImageUploader
                                withIcon={true}
                                buttonText={t.Chooseimages[lang]}
                                onChange={this.getAImages.bind(this)}
                                imgExtension={['.jpg', '.gif', '.png', '.gif']}
                                maxFileSize={5242880}
                                withPreview
                            />
                        </div>
                        <div className="col-md-12 text-center">
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-light" type="button"  onClick={ () => this.move('#tab-eg15-3', '#card-info-btn')}>{t.Previous[lang]}</button>
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-dark" type="button"  onClick={ () => this.move('#tab-eg15-5', '#card-links-btn')}>{t.Next[lang]}</button>
                        </div>
                      </div>
                    </div>
                    <div class="tab-pane show" id="tab-eg15-5" role="tabpanel">
                      <div className="form-row">
                        <div className="col-md-12">
                          <span forHtml="business-image" className="col-form-label btn-span">{t.AdditionalCardLinks[lang]}</span>
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "card_links")} checked={this.state.checked.card_links} />
                          </div>
                          <button className="d-block btn-mob" type="button" onClick={ () => this.addLinks("card_links") }>
                              <FontAwesomeIcon icon={faPlusSquare} />
                          </button>
                        </div>
                        <div className="col-md-12">
                          {this.state.card_links.map((links, index) => (
                            <div className="row">
                              <div className="col-md-12">
                                <div className="col-sm-1 p-0 m-0 d-inline-block text-center">
                                    <button className="close-btn" type="button" onClick={this.handleLinkDelete("card_links", index)}>
                                        <FontAwesomeIcon icon={faMinusSquare} />
                                    </button>
                                    <div>{index+1}</div>
                                </div>
                                <div className="col-sm-11 p-0 m-0 d-inline-block">
                                    <div key={index}>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("card_links",index, "title")}
                                              value={links.title}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-title" className={(links.title !== '') ? 'show' : ''}>{t.LinkTitle[lang]}</label>
                                        </div>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("card_links",index, "link")}
                                              value={links.link}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-link" className={(links.link !== '') ? 'show' : ''}>{t.CardLink[lang]}</label>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          ))}
                        </div>
                      </div>
                      <div className="form-row">
                        <div className="col-md-12">
                          <span forHtml="success-story" className="col-form-label btn-span">{t.SuccessStories[lang]}</span>
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "our_stories")} checked={this.state.checked.our_stories} />
                          </div>
                          <button className="d-block btn-mob" type="button" onClick={this.addStory}>
                              <FontAwesomeIcon icon={faPlusSquare} />
                          </button>
                        </div>
                        <div className="col-md-12">
                        {this.state.our_stories.map((story, index) => (
                              <div className="row">
                                <div className="col-md-12">
                                  <div className="col-sm-12 m-0 p-0 text-center">
                                    <div>
                                      <button style={{'text-align':'right'}} type="button" className="close-btn" onClick={this.handleStoryDelete(index)}>
                                          <FontAwesomeIcon icon={faMinusSquare} />
                                      </button>
                                    </div>
                                  </div>
                                  <div className="col-sm-12 m-0 p-0 d-inline-block text-center">
                                      <div key={index}>
                                          <textarea 
                                              className="form-control pull-left" value={story} 
                                              onChange={this.handleStoryText(index)} 
                                              placeholder={t.SuccessStories_p[lang]} rows="8"></textarea>
                                      </div>
                                  </div>
                                </div>
                              </div>
                          ))}
                        </div>
                      </div>

                      <hr/>

                      <div className="form-row">
                        <div className="col-md-12">
                          <span forHtml="success-story" className="col-form-label btn-span">{t.ActivityHour[lang]}</span>
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "activity_hour")} checked={this.state.checked.activity_hour} />
                          </div>
                          <button className="d-block btn-mob" type="button" onClick={this.addActivity}>
                              <FontAwesomeIcon icon={faPlusSquare} />
                          </button>
                        </div>
                        <div className="col-md-12">
                          {this.state.activity_hour.map((one, index) => (
                            <div className="row">
                              <div className="col-md-12">
                                <div className="col-sm-12 m-0 p-0 d-inline-block">
                                    <div key={index}>
                                        <div className="form-group">
                                            <button style={{'display':'inline-block', 'width': '4.2%'}} className="close-btn" type="button" onClick={this.handleActivityDelete(index)}>
                                                <FontAwesomeIcon icon={faMinusSquare} />
                                            </button>
                                            <select className="form-control" style={{'width':'50%', 'display':'inline-block'}} id="day-select" value={one.day} onChange={this.handleActivityDay(index,"day")}>
                                                <option value="">{t.SelectADay[lang]}</option>
                                                <option value="Monday">{t.Monday[lang]}</option>
                                                <option value="Tuesday">{t.Tuesday[lang]}</option>
                                                <option value="Wednesday">{t.Wednesday[lang]}</option>
                                                <option value="Thursday">{t.Thursday[lang]}</option>
                                                <option value="Friday">{t.Friday[lang]}</option>
                                                <option value="Saturday">{t.Saturday[lang]}</option>
                                                <option value="Sunday">{t.Sunday[lang]}</option>
                                            </select>
                                            <TimeRange
                                                startLabel = {t.From[lang]}
                                                endLabel = {t.To[lang]}
                                                startMoment={this.state.startTime[index]}
                                                endMoment={this.state.endTime[index]}
                                                onChange={this.handleActivityTime(index)}
                                            />
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          ))}
                        </div>
                      </div>

                      <hr/>

                      <div className="form-row">
                        <div className="col-md-12">
                          <span forHtml="articles" className="col-form-label btn-span">{t.Articles[lang]}</span>
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "articles")} checked={this.state.checked.articles} />
                          </div>
                          <button className="d-block btn-mob" type="button" onClick={ () => this.addLinks("articles") }>
                              <FontAwesomeIcon icon={faPlusSquare} />
                          </button>
                        </div>
                        <div className="col-md-12">
                          {this.state.articles.map((article, index) => (
                            <div className="row">
                              <div className="col-md-12">
                                <div className="col-sm-1 p-0 m-0 d-inline-block text-center">
                                    <button className="close-btn" type="button" onClick={this.handleLinkDelete("articles",index)}>
                                        <FontAwesomeIcon icon={faMinusSquare} />
                                    </button>
                                    <div>{index+1}</div>
                                </div>
                                <div className="col-sm-11 p-0 m-0 d-inline-block">
                                    <div key={index}>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("articles",index, "title")}
                                              value={article.title}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-title" className={(article.title !== '') ? 'show' : ''}>{t.ArticleTitle[lang]}</label>
                                        </div>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("articles",index, "link")}
                                              value={article.link}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-link" className={(article.link !== '') ? 'show' : ''}>{t.ArticleLink[lang]}</label>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          ))}
                        </div>
                      </div>

                      <hr/>

                      <div className="form-row">
                        <div className="col-md-12">
                          <span forHtml="employees" className="col-form-label btn-span">{t.Employees[lang]}</span>
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "employees")} checked={this.state.checked.employees} />
                          </div>
                          <button className="d-block btn-mob" type="button" onClick={ () => this.addLinks("employees") }>
                              <FontAwesomeIcon icon={faPlusSquare} />
                          </button>
                        </div>
                        <div className="col-md-12">
                          {this.state.employees.map((employee, index) => (
                            <div className="row">
                              <div className="col-md-12">
                                <div className="col-sm-1 p-0 m-0 d-inline-block text-center">
                                    <button className="close-btn" type="button" onClick={this.handleLinkDelete("employees",index)}>
                                        <FontAwesomeIcon icon={faMinusSquare} />
                                    </button>
                                    <div>{index+1}</div>
                                </div>
                                <div className="col-sm-11 p-0 m-0 d-inline-block">
                                    <div key={index}>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("employees",index, "title")}
                                              value={employee.title}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-title" className={(employee.title !== '') ? 'show' : ''}>{t.EmployeeTitle[lang]}</label>
                                        </div>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("employees",index, "link")}
                                              value={employee.link}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-link" className={(employee.link !== '') ? 'show' : ''}>{t.EmployeeLink[lang]}</label>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          ))}
                        </div>
                      </div>
                      <hr/>

                      <div className="form-row">
                        <div className="col-md-12">
                          <span forHtml="employees" className="col-form-label btn-span">{t.Recommendations[lang]}</span>
                          <div className="d-inline float-right">
                              <Switch className="switch-create-card" offColor="#212123" onColor="#00adb4" onChange={this.handleCardToggleFields.bind(this, "recommendations")} checked={this.state.checked.recommendations} />
                          </div>
                          <button className="d-block btn-mob" type="button" onClick={ () => this.addLinks("recommendations") }>
                              <FontAwesomeIcon icon={faPlusSquare} />
                          </button>
                        </div>
                        <div className="col-md-12">
                          {this.state.recommendations.map((rec, index) => (
                            <div className="row">
                              <div className="col-md-12">
                                <div className="col-sm-1 p-0 m-0 d-inline-block text-center">
                                    <button className="close-btn" type="button" onClick={this.handleLinkDelete("recommendations",index)}>
                                        <FontAwesomeIcon icon={faMinusSquare} />
                                    </button>
                                    <div>{index+1}</div>
                                </div>
                                <div className="col-sm-11 p-0 m-0 d-inline-block">
                                    <div key={index}>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("recommendations",index, "title")}
                                              value={rec.title}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-title" className={(rec.title !== '') ? 'show' : ''}>{t.RecommendationTitle[lang]}</label>
                                        </div>
                                        <div className="position-relative form-group">
                                          <input
                                              type="text"
                                              onChange={this.handleLinkText("recommendations",index, "link")}
                                              value={rec.link}
                                              className="form-control"
                                              />
                                          <label htmlFor="links-link" className={(rec.link !== '') ? 'show' : ''}>{t.RecommendationLink[lang]}</label>
                                        </div>
                                    </div>
                                </div>
                              </div>
                            </div>
                          ))}
                        </div>
                        <div className="col-md-12 text-center">
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-light" type="button"  onClick={ () => this.move('#tab-eg15-4', '#card-content-btn')}>{t.Previous[lang]}</button>
                          <button class="mb-2 mr-2 btn-hover-shine btn btn-wide btn-dark" type="button"  onClick={ this.createCard }>{t.Save[lang]}</button>
                        </div>
                      </div>
                    </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
      );

  }
}

const mapDispatchToProps = () => {
  return {
      getConfigurations: token => settingactionCreater.getConfigurations(token),
      slugs: (token) => actionCreater.getSlugs(token),
      createCard: (token, params) => actionCreater.createCard(token, params),
  };
};

export default connect(
  null,
  mapDispatchToProps
)(CreateCard);
